library Project1;

{ Important note about DLL memory management: ShareMem must be the
  first unit in your library's USES clause AND your project's (select
  Project-View Source) USES clause if your DLL exports any procedures or
  functions that pass strings as parameters or function results. This
  applies to all strings passed to and from your DLL--even those that
  are nested in records and classes. ShareMem is the interface unit to
  the BORLNDMM.DLL shared memory manager, which must be deployed along
  with your DLL. To avoid using BORLNDMM.DLL, pass string information
  using PChar or ShortString parameters. }

uses
  SysUtils,
  Classes,
  Dialogs, Windows;

{$R *.res}

procedure DllMain(Reason :Cardinal);
//procedure DllEntryPoint(Reason :Cardinal);
begin
case (reason) of
    DLL_PROCESS_ATTACH: ShowMessage('DllMain - DLL_PROCESS_ATTACH ');
    DLL_PROCESS_DETACH: ShowMessage('DllMain - DLL_PROCESS_DETACH ');
    DLL_THREAD_ATTACH: ShowMessage('DllMain - DLL_THREAD_ATTACH ');
    DLL_THREAD_DETACH: ShowMessage('DllMain - DLL_THREAD_DETACH ');
    end;
end;

//-------------------------------------------------------------------------

procedure Test1;
begin
ShowMessage('Test1 - Procedura znajduje si w bibliotece DLL');
end;

//-------------------------------------------------------------------------

procedure Test2; StdCall;
begin
ShowMessage('Test2 - Procedura znajduje si w bibliotece DLL');
end;

//-------------------------------------------------------------------------

procedure ProceduraWewnetrzna;
begin
ShowMessage('ProceduraWewnetrzna - Moe by wywoana tylko przez inny skadnik biblioteki DLL');
end;

procedure Test3; StdCall;
begin
ShowMessage('Test3 - Wywoanie procedury wewntrznej');
ProceduraWewnetrzna;
end;

//-------------------------------------------------------------------------

function Test4(argument :String) :Integer; StdCall;
begin
ShowMessage('Test4 - Wywoanie funkcji z biblioteki DLL'+#13+
'argument: "'+argument+'"'+#13+'Funkcja zwraca liczbe pseudolosow');
Randomize();
Test4:=Random(10000); //zwraca liczbe pseudolosowa
end;

//-------------------------------------------------------------------------

function Test5(argument :PChar) :Integer; StdCall;
begin
ShowMessage('Test5 - Wywoanie funkcji z biblioteki DLL'+#13+
'argument: "'+argument+'"'+#13+'Funkcja zwraca liczbe pseudolosow');
Randomize();
Test5:=Random(10000); //zwraca liczbe pseudolosowa
end;

//-------------------------------------------------------------------------

function Test6(pArgument :Pointer) :Integer; StdCall;
begin
ShowMessage('Test6 - Wywoanie funkcji z biblioteki DLL'+#13+
'argument: "'+String(pArgument^)+'"'+#13+'Funkcja zwraca liczbe pseudolosow');
Randomize();
Test6:=Random(10000); //zwraca liczbe pseudolosowa
end;

//-------------------------------------------------------------------------

exports
Test1, Test2, Test3, Test4, Test5, Test6;

begin
ShowMessage('aduj bibliotek Project1.dll');
//DLLProc:=@DllEntryPoint;
DLLProc:=@DllMain;
DllProc(DLL_PROCESS_ATTACH);
end.
